<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CleanTestData extends Command
{
    protected $signature = 'ads:clean-test-data';
    protected $description = 'Clean up test data';

    public function handle()
    {
        $this->info('🧹 Cleaning test data...');

        // Clean up test raw ads
        $rawCount = DB::table('ads_raw')->where('source', 'like', 'test%')->count();
        if ($rawCount > 0) {
            DB::table('ads_raw')->where('source', 'like', 'test%')->delete();
            $this->info("✅ Deleted {$rawCount} test raw ads");
        }

        // Clean up test opportunities
        $oppCount = DB::table('opportunities')->where('code', 'like', 'test%')->count();
        if ($oppCount > 0) {
            DB::table('opportunities')->where('code', 'like', 'test%')->delete();
            $this->info("✅ Deleted {$oppCount} test opportunities");
        }

        // Clean up test featured ads
        $featuredCount = DB::table('featured_ads')->where('title', 'like', '%تست%')->count();
        if ($featuredCount > 0) {
            DB::table('featured_ads')->where('title', 'like', '%تست%')->delete();
            $this->info("✅ Deleted {$featuredCount} test featured ads");
        }

        // Clean up test scrape profiles
        $profileCount = DB::table('scrape_profiles')->where('name', 'like', '%تست%')->count();
        if ($profileCount > 0) {
            DB::table('scrape_profiles')->where('name', 'like', '%تست%')->delete();
            $this->info("✅ Deleted {$profileCount} test scrape profiles");
        }

        $this->info('✅ Test data cleaned successfully!');
        return 0;
    }
}
