<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\ScoreOpportunitiesJob;

class ScoreOpportunitiesCommand extends Command
{
    protected $signature = 'ads:score-opportunities';
    protected $description = 'Score opportunities from raw ads';

    public function handle()
    {
        $this->info('🎯 Scoring opportunities...');

        $job = new ScoreOpportunitiesJob();
        $job->handle();

        $this->info('✅ Opportunities scored successfully!');

        return 0;
    }
}
