<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\Ads\MajidApiClient;

class TestMajidApi extends Command
{
    protected $signature = 'majid:test {action=latest} {--page=1} {--query=} {--code=} {--brand=}';
    protected $description = 'Test MajidAPI endpoints';

    public function handle()
    {
        $client = new MajidApiClient();
        $action = $this->argument('action');

        $this->info("Testing MajidAPI action: {$action}");

        switch ($action) {
            case 'latest':
                $page = (int) $this->option('page');
                $this->info("Fetching latest ads, page: {$page}");
                $result = $client->bamaLatest($page);
                break;

            case 'search':
                $query = $this->option('query') ?: 'پژو';
                $page = (int) $this->option('page');
                $this->info("Searching for: {$query}, page: {$page}");
                $result = $client->bamaSearch($query, $page);
                break;

            case 'details':
                $code = $this->option('code');
                if (!$code) {
                    $this->error('Code is required for details action');
                    return 1;
                }
                $this->info("Fetching details for code: {$code}");
                $result = $client->bamaDetails($code);
                break;

            case 'carPrice':
                $brand = $this->option('brand') ?: 'پژو';
                $this->info("Fetching car price for brand: {$brand}");
                $result = $client->bamaCarPrice($brand);
                break;

            case 'motorcyclePrice':
                $brand = $this->option('brand') ?: 'benelli';
                $this->info("Fetching motorcycle price for brand: {$brand}");
                $result = $client->bamaMotorcyclePrice($brand);
                break;

            default:
                $this->error("Unknown action: {$action}");
                $this->info("Available actions: latest, search, details, carPrice, motorcyclePrice");
                return 1;
        }

        if (empty($result)) {
            $this->warn('No data returned from API');
        } else {
            $this->info('API Response:');
            $this->line(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }

        return 0;
    }
}
