<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Push scheduler: runs at specific hours
        $schedule->job(\App\Jobs\PushSchedulerJob::class)->cron('0 9,11,14 * * *');

        // Score opportunities: every 30 minutes
        $schedule->job(\App\Jobs\ScoreOpportunitiesJob::class)->everyThirtyMinutes();

        // Growth daily tasks: once per day at 2 AM
        $schedule->job(\App\Jobs\GrowthDailyJob::class)->dailyAt('02:00');

        // Payments reconcile: hourly
        $schedule->job(\App\Jobs\PaymentsReconcileJob::class)->hourly();

        // Generate city reports: weekly on Sundays at 3 AM
        $schedule->job(\App\Jobs\GenerateCityReportJob::class)->weekly()->sundays()->at('03:00');
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
