<?php

namespace App\Contracts;

use App\DTOs\TelegramMessage;
use App\DTOs\TelegramCallback;
use App\DTOs\TelegramResponse;

interface TelegramModuleInterface
{
    /**
     * Get the unique module name identifier
     */
    public function getModuleName(): string;

    /**
     * Get the module version
     */
    public function getModuleVersion(): string;

    /**
     * Get array of required module dependencies
     */
    public function getDependencies(): array;

    /**
     * Handle incoming text message
     */
    public function handleMessage(TelegramMessage $message): ?TelegramResponse;

    /**
     * Handle callback query from inline keyboard
     */
    public function handleCallback(TelegramCallback $callback): ?TelegramResponse;

    /**
     * Get the configuration schema for this module
     */
    public function getConfigurationSchema(): array;

    /**
     * Install/initialize the module
     */
    public function install(): void;

    /**
     * Uninstall the module
     */
    public function uninstall(): void;

    /**
     * Check if module is enabled
     */
    public function isEnabled(): bool;

    /**
     * Get module priority (higher numbers run first)
     */
    public function getPriority(): int;
}