<?php

namespace App\DTOs;

class TelegramResponse
{
    public function __construct(
        public readonly string $text,
        public readonly ?array $keyboard = null,
        public readonly ?string $parseMode = null,
        public readonly bool $disablePreview = false,
        public readonly bool $handled = true
    ) {}

    public static function text(string $text, string $parseMode = null): self
    {
        return new self(text: $text, parseMode: $parseMode);
    }

    public static function withKeyboard(string $text, array $keyboard, string $parseMode = null): self
    {
        return new self(text: $text, keyboard: $keyboard, parseMode: $parseMode);
    }

    public static function notHandled(): self
    {
        return new self(text: '', handled: false);
    }

    public function isHandled(): bool
    {
        return $this->handled;
    }

    public function hasKeyboard(): bool
    {
        return $this->keyboard !== null;
    }
}