<?php

namespace App\Filament\Resources\BroadcastCampaignResource\Pages;

use App\Filament\Resources\BroadcastCampaignResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;
use App\Services\Notification\NotificationService;

class ViewBroadcastCampaign extends ViewRecord
{
    protected static string $resource = BroadcastCampaignResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make()
                ->visible(fn () => $this->record->isEditable()),
                
            Actions\Action::make('send')
                ->label('Send Campaign')
                ->icon('heroicon-o-paper-airplane')
                ->color('success')
                ->visible(fn () => in_array($this->record->status, ['draft', 'scheduled', 'paused']))
                ->requiresConfirmation()
                ->action(function () {
                    app(NotificationService::class)->sendCampaign($this->record);
                    $this->refreshFormData(['status', 'started_at']);
                }),
                
            Actions\Action::make('pause')
                ->label('Pause Campaign')
                ->icon('heroicon-o-pause')
                ->color('warning')
                ->visible(fn () => $this->record->status === 'sending')
                ->requiresConfirmation()
                ->action(function () {
                    $this->record->pause();
                    $this->refreshFormData(['status']);
                }),
                
            Actions\Action::make('resume')
                ->label('Resume Campaign')
                ->icon('heroicon-o-play')
                ->color('primary')
                ->visible(fn () => $this->record->status === 'paused')
                ->requiresConfirmation()
                ->action(function () {
                    app(NotificationService::class)->resumeCampaign($this->record->id);
                    $this->refreshFormData(['status']);
                }),
                
            Actions\Action::make('cancel')
                ->label('Cancel Campaign')
                ->icon('heroicon-o-x-mark')
                ->color('danger')
                ->visible(fn () => !$this->record->isCompleted())
                ->requiresConfirmation()
                ->action(function () {
                    $this->record->cancel();
                    $this->refreshFormData(['status', 'completed_at']);
                }),
                
            Actions\Action::make('regenerate_recipients')
                ->label('Regenerate Recipients')
                ->icon('heroicon-o-arrow-path')
                ->color('gray')
                ->visible(fn () => $this->record->status === 'draft')
                ->requiresConfirmation()
                ->action(function () {
                    // Delete existing recipients
                    $this->record->recipients()->delete();
                    
                    // Regenerate recipients
                    app(NotificationService::class)->generateRecipients($this->record);
                    $this->refreshFormData(['total_recipients']);
                }),
        ];
    }

    protected function getHeaderWidgets(): array
    {
        return [
            BroadcastCampaignResource\Widgets\CampaignProgressWidget::class,
        ];
    }
}