<?php

namespace App\Filament\Resources\FeaturedAdsResource\Pages;

use App\Filament\Resources\FeaturedAdsResource;
use Filament\Resources\Pages\CreateRecord;

class CreateFeaturedAd extends CreateRecord
{
    protected static string $resource = FeaturedAdsResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // Convert arrays to JSON for storage
        if (isset($data['target_roles']) && is_array($data['target_roles'])) {
            $data['target_roles'] = json_encode($data['target_roles']);
        }

        if (isset($data['target_cities']) && is_array($data['target_cities'])) {
            $data['target_cities'] = json_encode($data['target_cities']);
        }

        return $data;
    }
}
