<?php

namespace App\Filament\Resources\FeaturedAdsResource\Pages;

use App\Filament\Resources\FeaturedAdsResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditFeaturedAd extends EditRecord
{
    protected static string $resource = FeaturedAdsResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Convert JSON to arrays for form
        if (isset($data['target_roles']) && is_string($data['target_roles'])) {
            $data['target_roles'] = json_decode($data['target_roles'], true) ?: [];
        }

        if (isset($data['target_cities']) && is_string($data['target_cities'])) {
            $data['target_cities'] = json_decode($data['target_cities'], true) ?: [];
        }

        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Convert arrays to JSON for storage
        if (isset($data['target_roles']) && is_array($data['target_roles'])) {
            $data['target_roles'] = json_encode($data['target_roles']);
        }

        if (isset($data['target_cities']) && is_array($data['target_cities'])) {
            $data['target_cities'] = json_encode($data['target_cities']);
        }

        return $data;
    }
}
