<?php

namespace App\Filament\Resources\SettingResource\Pages;

use App\Filament\Resources\SettingResource;
use Filament\Resources\Pages\CreateRecord;
use App\Services\Core\ConfigurationManager;

class CreateSetting extends CreateRecord
{
    protected static string $resource = SettingResource::class;

    protected function afterCreate(): void
    {
        // Clear configuration cache after creating a new setting
        if (app()->has(ConfigurationManager::class)) {
            app(ConfigurationManager::class)->clearCache();
        }
    }
}