<?php

namespace App\Filament\Resources\SettingResource\Pages;

use App\Filament\Resources\SettingResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use App\Services\Core\ConfigurationManager;

class EditSetting extends EditRecord
{
    protected static string $resource = SettingResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function afterSave(): void
    {
        // Clear configuration cache after updating a setting
        if (app()->has(ConfigurationManager::class)) {
            app(ConfigurationManager::class)->clearCache();
        }
    }
}