<?php

namespace App\Filament\Widgets;

use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Log;

class RecentErrors extends BaseWidget
{
    protected static ?string $heading = 'خطاهای اخیر سیستم';

    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                \Illuminate\Support\Facades\DB::table('logs')
                    ->where('level', 'error')
                    ->orderBy('created_at', 'desc')
                    ->limit(10)
            )
            ->columns([
                Tables\Columns\TextColumn::make('created_at')
                    ->label('زمان')
                    ->dateTime('Y/m/d H:i:s')
                    ->sortable(),

                Tables\Columns\BadgeColumn::make('level')
                    ->label('سطح')
                    ->formatStateUsing(fn (string $state): string => match($state) {
                        'error' => 'خطا',
                        'warning' => 'هشدار',
                        'info' => 'اطلاعات',
                        default => $state,
                    })
                    ->color(fn (string $state): string => match($state) {
                        'error' => 'danger',
                        'warning' => 'warning',
                        'info' => 'info',
                        default => 'gray',
                    }),

                Tables\Columns\TextColumn::make('message')
                    ->label('پیام')
                    ->limit(100)
                    ->tooltip(function (Tables\Columns\TextColumn $column): ?string {
                        $state = $column->getState();
                        return strlen($state) > 100 ? $state : null;
                    }),

                Tables\Columns\TextColumn::make('context')
                    ->label('زمینه')
                    ->formatStateUsing(function ($state) {
                        if (!$state) return '-';
                        $context = json_decode($state, true);
                        if (isset($context['exception'])) {
                            return 'Exception: ' . substr($context['exception'], 0, 50) . '...';
                        }
                        return json_encode($context, JSON_UNESCAPED_UNICODE);
                    })
                    ->limit(50),
            ])
            ->defaultSort('created_at', 'desc')
            ->emptyStateHeading('هیچ خطایی یافت نشد')
            ->emptyStateDescription('سیستم بدون خطا کار می‌کند.');
    }
}
