<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use App\Http\Requests\AdminTicketReplyRequest;
use Illuminate\Support\Facades\DB;

class TicketsController extends Controller
{
    public function reply(int $id, AdminTicketReplyRequest $request): JsonResponse
    {
        DB::table('tickets')->where('id',$id)->update([
            'admin_last_reply_text' => $request->validated()['body'],
            'admin_replied_at' => now(),
            'updated_at' => now(),
        ]);
        $t = DB::table('tickets')->where('id',$id)->first();
        return response()->json(['id' => $id, 'status' => $t->status, 'admin_replied_at' => optional($t->admin_replied_at)->toDateTimeString()]);
    }
}
