<?php

namespace App\Http\Controllers\Support;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests\TicketStoreRequest;
use Illuminate\Support\Facades\DB;

class TicketsController extends Controller
{
    public function store(TicketStoreRequest $request): JsonResponse
    {
        $userId = optional($request->user())->id ?? 239053159;
        $id = DB::table('tickets')->insertGetId([
            'user_id' => $userId,
            'subject' => $request->validated()['subject'],
            'body' => $request->validated()['body'],
            'status' => 'open',
            'created_at' => now(), 'updated_at' => now(),
        ]);
        return response()->json(['id' => $id, 'status' => 'open']);
    }

    public function index(Request $request): JsonResponse
    {
        $userId = optional($request->user())->id ?? 239053159;
        $items = DB::table('tickets')->where('user_id',$userId)->orderByDesc('id')->limit(50)->get();
        return response()->json(['items' => $items]);
    }
}
