<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SimulateProtect
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!app()->environment('local')) {
            return response()->json(['error' => 'forbidden', 'message' => 'Simulation only allowed in local env'], 403);
        }
        return $next($request);
    }
}

