<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AiRespondRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'model' => ['sometimes','string'],
            'store' => ['sometimes','boolean'],
            'previous_response_id' => ['nullable','string'],
            'tool_resources' => ['sometimes','array'],
            'tool_resources.file_search' => ['sometimes','array'],
            'tool_resources.file_search.vector_store_ids' => ['sometimes','array'],
            'tool_resources.file_search.vector_store_ids.*' => ['string'],
            'input' => ['required','array','min:1'],
            'input.*.role' => ['required','in:system,user,assistant'],
            'input.*.content' => ['required','string'],
            'response_format' => ['sometimes','array'],
            'response_format.type' => ['sometimes','in:json_object'],
        ];
    }
}

