<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PaymentVerifyRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    protected function prepareForValidation(): void
    {
        // Normalize case-insensitive query params from gateway (Authority, Status)
        $data = $this->all();
        $authority = $data['authority']
            ?? $data['Authority']
            ?? $data['AUTHORITY']
            ?? null;
        $status = $data['status']
            ?? $data['Status']
            ?? $data['STATUS']
            ?? null;
        $this->merge([
            'authority' => $authority,
            'status' => $status,
        ]);
    }

    public function rules(): array
    {
        return [
            'authority' => ['required','string'],
            'status' => ['nullable','string'],
        ];
    }
}
