<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SavedAdStoreRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'source' => ['required', Rule::in(['opportunity','external'])],

            // Opportunity variant
            'opportunity_id' => [
                'required_if:source,opportunity',
                'prohibited_unless:source,opportunity',
                'integer','exists:opportunities,id'
            ],

            // External variant
            'external_source' => [
                'required_if:source,external',
                'prohibited_unless:source,external',
                Rule::in(['bama','divar'])
            ],
            'external_code' => [
                'required_if:source,external',
                'prohibited_unless:source,external',
                'string'
            ],
            'link' => [
                'required_if:source,external',
                'prohibited_unless:source,external',
                'url'
            ],
        ];
    }
}

