<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'province',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function opportunities()
    {
        return $this->hasMany(Opportunity::class);
    }

    public function aliases()
    {
        return $this->hasMany(CityAlias::class);
    }
}
