<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;

    protected $fillable = [
        'key',
        'name',
        'amount_irr',
        'duration_days',
        'is_active',
        'description',
        'features',
    ];

    protected $casts = [
        'amount_irr' => 'integer',
        'duration_days' => 'integer',
        'is_active' => 'boolean',
        'features' => 'array',
    ];

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function getFormattedAmountAttribute(): string
    {
        return number_format($this->amount_irr) . ' تومان';
    }

    public function getFormattedDurationAttribute(): string
    {
        if ($this->duration_days < 30) {
            return $this->duration_days . ' روز';
        } elseif ($this->duration_days < 365) {
            return round($this->duration_days / 30) . ' ماه';
        } else {
            return round($this->duration_days / 365) . ' سال';
        }
    }
}
