<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PromptConfig extends Model
{
    use HasFactory;

    protected $fillable = [
        'module',
        'model',
        'temperature',
        'top_p',
        'enable_file_search',
        'system_prompt',
        'user_prompt_template',
    ];

    protected $casts = [
        'temperature' => 'float',
        'top_p' => 'float',
        'enable_file_search' => 'boolean',
    ];

    public static function getForModule(string $module): ?self
    {
        return static::where('module', $module)->first();
    }

    public function getModuleDisplayNameAttribute(): string
    {
        return match ($this->module) {
            'valuation' => 'قیمت‌یار',
            'negotiation' => 'تمرین مذاکره',
            'expert' => 'سؤالات کارشناسی',
            'legal' => 'سؤالات حقوقی',
            'inspection' => 'بازدید',
            'instagram' => 'ایده اینستاگرام',
            default => $this->module
        };
    }

    public function getModelDisplayNameAttribute(): string
    {
        return match ($this->model) {
            'gpt-4o-mini' => 'GPT-4o Mini',
            'gpt-4o' => 'GPT-4o',
            'gpt-3.5-turbo' => 'GPT-3.5 Turbo',
            default => $this->model
        };
    }
}
