<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PushLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'campaign_id',
        'sent_at',
        'delivered_at',
        'opened_at',
        'clicked_cta_at',
        'error_message',
    ];

    protected $casts = [
        'sent_at' => 'datetime',
        'delivered_at' => 'datetime',
        'opened_at' => 'datetime',
        'clicked_cta_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function campaign()
    {
        return $this->belongsTo(PushCampaign::class);
    }

    public function isDelivered(): bool
    {
        return !is_null($this->delivered_at);
    }

    public function isOpened(): bool
    {
        return !is_null($this->opened_at);
    }

    public function isClicked(): bool
    {
        return !is_null($this->clicked_cta_at);
    }
}
