<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VectorFile extends Model
{
    use HasFactory;

    protected $fillable = [
        'vector_store_id',
        'openai_file_id',
        'tag',
        'status',
        'file_name',
        'file_size',
    ];

    public function vectorStore()
    {
        return $this->belongsTo(VectorStore::class);
    }

    public function getStatusColorAttribute(): string
    {
        return match ($this->status) {
            'uploaded' => 'blue',
            'processing' => 'yellow',
            'completed' => 'green',
            'failed' => 'red',
            default => 'gray'
        };
    }

    public function getStatusTextAttribute(): string
    {
        return match ($this->status) {
            'uploaded' => 'آپلود شده',
            'processing' => 'در حال پردازش',
            'completed' => 'تکمیل شده',
            'failed' => 'ناموفق',
            default => $this->status
        };
    }

    public function getFormattedSizeAttribute(): string
    {
        if (!$this->file_size) return '-';

        $units = ['B', 'KB', 'MB', 'GB'];
        $bytes = $this->file_size;
        $i = 0;

        while ($bytes >= 1024 && $i < count($units) - 1) {
            $bytes /= 1024;
            $i++;
        }

        return round($bytes, 2) . ' ' . $units[$i];
    }
}
