<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VectorStore extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'openai_vector_store_id',
        'is_active',
        'description',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function vectorFiles()
    {
        return $this->hasMany(VectorFile::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function getStatusColorAttribute(): string
    {
        return $this->is_active ? 'green' : 'gray';
    }

    public function getStatusTextAttribute(): string
    {
        return $this->is_active ? 'فعال' : 'غیرفعال';
    }

    public function getFileCountAttribute(): int
    {
        return $this->vectorFiles()->count();
    }
}
