<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Bind LLM Provider interface to OpenAI implementation
        $this->app->bind(
            \App\Services\AI\LlmProvider::class,
            \App\Services\AI\OpenAiProvider::class
        );

        // Register TelegramBot as singleton
        $this->app->singleton(
            \App\Services\Messaging\TelegramBot::class,
            \App\Services\Messaging\TelegramBot::class
        );

        // Register InspectionService as singleton
        $this->app->singleton(
            \App\Services\Inspection\InspectionService::class,
            \App\Services\Inspection\InspectionService::class
        );
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
