<?php

return [
    /*
    |--------------------------------------------------------------------------
    | cPanel Laravel Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for deploying Laravel applications on cPanel hosting
    |
    */

    'deployment' => [
        'public_html_symlink' => true,
        'storage_symlink' => true,
        'optimize_for_cpanel' => true,
    ],

    'paths' => [
        'public_html' => '/public_html',
        'app_root' => '/larbot_template',
        'storage' => '/storage',
        'logs' => '/storage/logs',
    ],

    'database' => [
        'mysql_version' => '8.0',
        'charset' => 'utf8mb4',
        'collation' => 'utf8mb4_unicode_ci',
    ],

    'queue' => [
        'driver' => 'database',
        'retry_after' => 90,
        'timeout' => 60,
    ],

    'cache' => [
        'driver' => 'file',
        'prefix' => 'larbot_',
    ],

    'session' => [
        'driver' => 'file',
        'lifetime' => 120,
    ],

    'optimization' => [
        'config_cache' => true,
        'route_cache' => true,
        'view_cache' => true,
        'opcache' => true,
    ],

    'security' => [
        'hide_laravel_headers' => true,
        'disable_debug_mode' => true,
        'force_https' => false, // Set based on hosting
    ],
];