<?php

namespace Database\Factories;

use App\Models\Inspection;
use App\Models\User;
use App\Models\Opportunity;
use Illuminate\Database\Eloquent\Factories\Factory;

class InspectionFactory extends Factory
{
    protected $model = Inspection::class;

    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'ad_id' => null,
            'inspection_type' => $this->faker->randomElement(['buy', 'sell']),
            'status' => $this->faker->randomElement(['in_progress', 'completed', 'cancelled']),
            'risk_score' => $this->faker->numberBetween(0, 100),
            'risk_level' => $this->faker->randomElement(['low', 'medium', 'high']),
            'recommendations' => [
                'توصیه ۱: این خودرو مناسب است',
                'توصیه ۲: قیمت منصفانه است',
                'توصیه ۳: مدارک را بررسی کنید'
            ],
            'answers' => [
                'exterior_condition' => $this->faker->randomElement(['عالی', 'خوب', 'متوسط', 'ضعیف']),
                'engine_condition' => $this->faker->randomElement(['عالی', 'خوب', 'متوسط', 'ضعیف']),
                'test_drive' => $this->faker->randomElement(['بله، عالی', 'بله، خوب', 'بله، متوسط', 'خیر']),
            ],
            'current_question' => $this->faker->numberBetween(0, 7),
            'completed_at' => $this->faker->optional(0.7)->dateTimeBetween('-1 month', 'now'),
        ];
    }

    public function inProgress(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'in_progress',
            'risk_score' => null,
            'risk_level' => null,
            'recommendations' => null,
            'completed_at' => null,
        ]);
    }

    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'completed',
            'risk_score' => $this->faker->numberBetween(60, 100),
            'risk_level' => $this->faker->randomElement(['low', 'medium']),
            'completed_at' => $this->faker->dateTimeBetween('-1 month', 'now'),
        ]);
    }

    public function cancelled(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'cancelled',
            'risk_score' => null,
            'risk_level' => null,
            'recommendations' => null,
            'completed_at' => null,
        ]);
    }

    public function buy(): static
    {
        return $this->state(fn (array $attributes) => [
            'inspection_type' => 'buy',
        ]);
    }

    public function sell(): static
    {
        return $this->state(fn (array $attributes) => [
            'inspection_type' => 'sell',
        ]);
    }

    public function highRisk(): static
    {
        return $this->state(fn (array $attributes) => [
            'risk_score' => $this->faker->numberBetween(0, 59),
            'risk_level' => 'high',
            'recommendations' => [
                '⚠️ ریسک بالا: خرید این خودرو توصیه نمی‌شود',
                '🔍 بررسی دقیق‌تر توسط مکانیک متخصص ضروری است',
                '💰 قیمت باید حداقل ۲۰٪ کمتر از بازار باشد'
            ],
        ]);
    }

    public function lowRisk(): static
    {
        return $this->state(fn (array $attributes) => [
            'risk_score' => $this->faker->numberBetween(80, 100),
            'risk_level' => 'low',
            'recommendations' => [
                '✅ ریسک پایین: خودرو مناسب برای خرید',
                '🎯 قیمت منصفانه است',
                '📋 مدارک را بررسی کنید'
            ],
        ]);
    }
}
