<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->json('value')->nullable();
            $table->enum('type', ['string', 'integer', 'boolean', 'json', 'array', 'float'])->default('string');
            $table->string('category')->default('general');
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_encrypted')->default(false);
            $table->json('validation_rules')->nullable();
            $table->json('options')->nullable(); // For dropdown/select options
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['category', 'is_active']);
            $table->index('key');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};