<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_pages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->longText('content')->nullable();
            $table->text('excerpt')->nullable();
            $table->string('language', 5)->default('fa');
            $table->enum('status', ['draft', 'published', 'archived'])->default('draft');
            $table->string('template')->default('default');
            $table->string('seo_title')->nullable();
            $table->text('seo_description')->nullable();
            $table->text('seo_keywords')->nullable();
            $table->string('featured_image')->nullable();
            $table->foreignId('author_id')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('published_at')->nullable();
            $table->json('related_pages')->nullable();
            $table->json('tags')->nullable();
            $table->json('metadata')->nullable();
            $table->bigInteger('view_count')->default(0);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['status', 'published_at']);
            $table->index(['language', 'status']);
            $table->index('slug');
            $table->index('view_count');
        });

        Schema::create('menu_items', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug');
            $table->text('description')->nullable();
            $table->text('keywords')->nullable(); // For text matching
            $table->string('icon')->nullable();
            $table->foreignId('parent_id')->nullable()->constrained('menu_items')->cascadeOnDelete();
            $table->foreignId('content_page_id')->nullable()->constrained('content_pages')->nullOnDelete();
            $table->enum('action_type', ['show_submenu', 'show_page', 'external_url', 'callback', 'command'])
                ->default('show_submenu');
            $table->json('action_data')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->boolean('is_visible')->default(true);
            $table->json('roles')->nullable(); // Roles that can access this menu
            $table->json('metadata')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['parent_id', 'is_active', 'sort_order']);
            $table->index(['slug', 'is_active']);
            $table->index('is_active');
            $table->unique(['parent_id', 'slug']); // Unique slug within same parent
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('menu_items');
        Schema::dropIfExists('content_pages');
    }
};