<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('menu_items', function (Blueprint $table) {
            $table->id();
            $table->string('key')->index();
            $table->string('title');
            $table->string('emoji', 16)->nullable();
            $table->boolean('enabled')->default(true);
            $table->integer('ord')->default(0);
            $table->json('visible_roles')->nullable();
            $table->timestamps();
        });

        Schema::create('prompt_configs', function (Blueprint $table) {
            $table->id();
            $table->string('module')->index();
            $table->string('model')->default('gpt-4o-mini');
            $table->float('temperature')->default(0.7);
            $table->float('top_p')->default(1.0);
            $table->boolean('enable_file_search')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prompt_configs');
        Schema::dropIfExists('menu_items');
    }
};

