<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('vector_stores', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('openai_vector_store_id')->unique();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('vector_files', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vector_store_id')->constrained('vector_stores')->cascadeOnDelete();
            $table->string('openai_file_id')->unique();
            $table->string('tag')->nullable();
            $table->string('status')->default('pending');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vector_files');
        Schema::dropIfExists('vector_stores');
    }
};

