<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('legal_files', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // buy|sell
            $table->string('file_path');
            $table->timestamps();
        });

        Schema::create('checklists', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type'); // inspection_buy|inspection_sell
            $table->json('questions_json');
            $table->timestamps();
        });

        Schema::create('city_reports', function (Blueprint $table) {
            $table->id();
            $table->string('city');
            $table->unsignedInteger('week_no');
            $table->json('summary_json');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('city_reports');
        Schema::dropIfExists('checklists');
        Schema::dropIfExists('legal_files');
    }
};

