<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('plan_entitlements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plan_id')->constrained('plans')->cascadeOnDelete();
            $table->string('key'); // e.g., cities, instant_push_per_day, valuations_per_month
            $table->integer('int_value')->nullable();
            $table->json('json_value')->nullable();
            $table->timestamps();
            $table->unique(['plan_id','key']);
        });

        Schema::create('user_quotas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->string('key'); // e.g., valuations_per_month, instant_push_per_day
            $table->integer('used')->default(0);
            // V-- FIX: Added ->nullable() to both timestamp columns --V
            $table->timestamp('period_start')->nullable();
            $table->timestamp('period_end')->nullable();
            // ^-- FIX: Added ->nullable() to both timestamp columns --^
            $table->timestamps();
            $table->index(['user_id','key']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_quotas');
        Schema::dropIfExists('plan_entitlements');
    }
};
