<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('wallet_ledger', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->string('type'); // credit|debit
            $table->integer('amount_irr');
            $table->string('reason')->nullable();
            $table->json('meta_json')->nullable();
            $table->timestamps();
        });

        Schema::create('trials', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->string('status')->default('active'); // active|penalized|ended
            $table->timestamp('started_at')->nullable();
            $table->timestamp('ends_at')->nullable();
            $table->integer('penalty_points')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('trials');
        Schema::dropIfExists('wallet_ledger');
    }
};

