<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('experiments', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->json('variant_keys');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('experiment_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('experiment_id')->constrained('experiments')->cascadeOnDelete();
            $table->string('variant_key');
            $table->timestamp('assigned_at')->nullable();
            $table->timestamps();
            $table->unique(['user_id','experiment_id']);
        });

        Schema::create('push_campaigns', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->string('name');
            $table->json('payload_json')->nullable();
            $table->json('schedule_json')->nullable();
            $table->string('status')->default('draft');
            $table->timestamps();
        });

        Schema::create('push_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('campaign_id')->constrained('push_campaigns')->cascadeOnDelete();
            $table->timestamp('delivered_at')->nullable();
            $table->timestamp('opened_at')->nullable();
            $table->timestamp('clicked_cta_at')->nullable();
            $table->json('meta_json')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('push_logs');
        Schema::dropIfExists('push_campaigns');
        Schema::dropIfExists('experiment_assignments');
        Schema::dropIfExists('experiments');
    }
};

