<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Check if cities table exists
        if (!Schema::hasTable('cities')) {
            return;
        }

        // Get existing cities
        $existingCities = DB::table('cities')->pluck('name')->toArray();

        // Cities to insert (only if they don't exist)
        $citiesToInsert = [
            ['name' => 'همدان', 'province' => 'همدان', 'is_major' => true],
            ['name' => 'یزد', 'province' => 'یزد', 'is_major' => true],
            ['name' => 'اردبیل', 'province' => 'اردبیل', 'is_major' => true],
            ['name' => 'بندرعباس', 'province' => 'هرمزگان', 'is_major' => true],
            ['name' => 'اراک', 'province' => 'مرکزی', 'is_major' => true],
            ['name' => 'زنجان', 'province' => 'زنجان', 'is_major' => true],
            ['name' => 'سنندج', 'province' => 'کردستان', 'is_major' => true],
            ['name' => 'ساری', 'province' => 'مازندران', 'is_major' => true],
            ['name' => 'قزوین', 'province' => 'قزوین', 'is_major' => true],
            ['name' => 'بوشهر', 'province' => 'بوشهر', 'is_major' => true],
            ['name' => 'آبادان', 'province' => 'خوزستان', 'is_major' => true],
            ['name' => 'خرم‌آباد', 'province' => 'لرستان', 'is_major' => true],
            ['name' => 'سمنان', 'province' => 'سمنان', 'is_major' => true],
            ['name' => 'شاهرود', 'province' => 'سمنان', 'is_major' => false],
            ['name' => 'کاشان', 'province' => 'اصفهان', 'is_major' => false],
            ['name' => 'دزفول', 'province' => 'خوزستان', 'is_major' => false],
        ];

        // Insert only cities that don't exist
        foreach ($citiesToInsert as $city) {
            if (!in_array($city['name'], $existingCities)) {
                DB::table('cities')->insert([
                    'name' => $city['name'],
                    'province' => $city['province'],
                    'is_major' => $city['is_major'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }

    public function down(): void
    {
        DB::table('cities')->truncate();
    }
};
