<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ChecklistsSeeder extends Seeder
{
    public function run(): void
    {
        $items = [
            ['name' => 'Inspection (Buy) — Quick', 'type' => 'inspection_buy', 'questions_json' => json_encode(['بدنه', 'موتور', 'اسناد'])],
            ['name' => 'Inspection (Sell) — Quick', 'type' => 'inspection_sell', 'questions_json' => json_encode(['بدنه', 'موتور', 'اسناد'])],
        ];
        foreach ($items as $i) {
            DB::table('checklists')->updateOrInsert(['name' => $i['name']], array_merge($i, [
                'created_at' => now(), 'updated_at' => now(),
            ]));
        }
    }
}

