<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CitiesSeeder extends Seeder
{
    public function run(): void
    {
        // Starter set; extend as needed
        $cities = [
            ['name' => 'Tehran', 'province' => 'Tehran'],
            ['name' => 'Mashhad', 'province' => 'Razavi Khorasan'],
            ['name' => 'Isfahan', 'province' => 'Isfahan'],
            ['name' => 'Shiraz', 'province' => 'Fars'],
            ['name' => 'Tabriz', 'province' => 'East Azerbaijan'],
        ];
        foreach ($cities as $c) {
            $id = DB::table('cities')->updateOrInsert(['name' => $c['name']], array_merge($c, [
                'created_at' => now(), 'updated_at' => now(),
            ]));
        }

        // Aliases (examples)
        $aliases = [
            ['alias' => 'تهران', 'city' => 'Tehran'],
            ['alias' => 'مشهد', 'city' => 'Mashhad'],
            ['alias' => 'اصفهان', 'city' => 'Isfahan'],
            ['alias' => 'شیراز', 'city' => 'Shiraz'],
            ['alias' => 'تبریز', 'city' => 'Tabriz'],
        ];
        foreach ($aliases as $a) {
            $city = DB::table('cities')->where('name', $a['city'])->first();
            if ($city) {
                DB::table('city_aliases')->updateOrInsert(
                    ['alias' => $a['alias']],
                    ['city_id' => $city->id, 'created_at' => now(), 'updated_at' => now()]
                );
            }
        }
    }
}

