<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\CityReport;

class CityReportsSeeder extends Seeder
{
    public function run(): void
    {
        $currentWeek = CityReport::getCurrentWeekNumber();

        // Sample city reports
        $cities = [
            'تهران' => [
                'market_overview' => 'بازار خودرو تهران در هفته گذشته با رشد ۲٪ قیمت‌ها همراه بوده است. تقاضا برای خودروهای کمپانی افزایش یافته.',
                'price_trends' => '• پراید: ۱۸۰-۲۰۰ میلیون\n• ۲۰۶: ۲۵۰-۲۸۰ میلیون\n• سمند: ۲۲۰-۲۵۰ میلیون',
                'recommendations' => '• برای خرید: منتظر کاهش قیمت‌ها در ۲ هفته آینده باشید\n• برای فروش: زمان مناسبی است، قیمت‌ها در اوج',
                'opportunities' => '• پراید ۱۳۹۸ زیر ۱۹۰ میلیون\n• ۲۰۶ تیپ ۵ زیر ۲۷۰ میلیون'
            ],
            'اصفهان' => [
                'market_overview' => 'بازار اصفهان نسبت به تهران آرام‌تر بوده و قیمت‌ها تقریباً ثابت مانده‌اند.',
                'price_trends' => '• پراید: ۱۷۰-۱۹۰ میلیون\n• ۲۰۶: ۲۴۰-۲۷۰ میلیون\n• سمند: ۲۱۰-۲۴۰ میلیون',
                'recommendations' => '• برای خرید: زمان مناسب، قیمت‌ها پایدار\n• برای فروش: عجله نکنید، بازار در حال رشد',
                'opportunities' => '• سمند ۱۴۰۰ زیر ۲۳۰ میلیون\n• ۲۰۶ صندوقدار زیر ۲۶۰ میلیون'
            ],
            'مشهد' => [
                'market_overview' => 'بازار مشهد با کمبود عرضه مواجه است و قیمت‌ها رو به افزایش.',
                'price_trends' => '• پراید: ۱۷۵-۱۹۵ میلیون\n• ۲۰۶: ۲۴۵-۲۷۵ میلیون\n• سمند: ۲۱۵-۲۴۵ میلیون',
                'recommendations' => '• برای خرید: سریع تصمیم بگیرید، قیمت‌ها در حال افزایش\n• برای فروش: فرصت عالی',
                'opportunities' => '• پراید ۱۳۹۹ زیر ۱۸۵ میلیون\n• سمند دوگانه زیر ۲۳۵ میلیون'
            ]
        ];

        foreach ($cities as $city => $data) {
            CityReport::updateOrCreate(
                [
                    'city' => $city,
                    'week_no' => $currentWeek
                ],
                [
                    'summary_json' => $data
                ]
            );
        }
    }
}
