<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\LegalFile;

class LegalFilesSeeder extends Seeder
{
    public function run(): void
    {
        // Create sample contract file entry
        LegalFile::updateOrCreate(
            ['type' => 'sample'],
            [
                'file_path' => 'contracts/sample_contract.pdf',
            ]
        );

        // Create sample contract files entries
        LegalFile::updateOrCreate(
            ['type' => LegalFile::TYPE_BUY],
            [
                'file_path' => 'contracts/buy_contract_template.txt',
            ]
        );

        LegalFile::updateOrCreate(
            ['type' => LegalFile::TYPE_SELL],
            [
                'file_path' => 'contracts/sell_contract_template.txt',
            ]
        );
    }
}
