<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MajorCitiesSeeder extends Seeder
{
    public function run(): void
    {
        $cities = [
            ['name' => 'تهران', 'province' => 'تهران', 'is_major' => true],
            ['name' => 'اصفهان', 'province' => 'اصفهان', 'is_major' => true],
            ['name' => 'مشهد', 'province' => 'خراسان رضوی', 'is_major' => true],
            ['name' => 'تبریز', 'province' => 'آذربایجان شرقی', 'is_major' => true],
            ['name' => 'شیراز', 'province' => 'فارس', 'is_major' => true],
        ];

        foreach ($cities as $city) {
            DB::table('cities')->updateOrInsert(
                ['name' => $city['name']],
                [
                    'name' => $city['name'],
                    'province' => $city['province'],
                    'is_major' => $city['is_major'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
        }
    }
}
