<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MenuSeeder extends Seeder
{
    public function run(): void
    {
        $items = [
            ['key' => 'opportunities', 'title' => 'فرصت‌های امروز', 'emoji' => '🔎', 'ord' => 1],
            ['key' => 'affordable_ads', 'title' => 'آگهی‌های به‌قیمت', 'emoji' => '💸', 'ord' => 2],
            ['key' => 'featured_ads', 'title' => 'آگهی‌های ویژه', 'emoji' => '⭐', 'ord' => 3],
            ['key' => 'valuation', 'title' => 'قیمت‌یار', 'emoji' => '💰', 'ord' => 4],
            ['key' => 'negotiation', 'title' => 'تمرین مذاکره', 'emoji' => '🗣️', 'ord' => 5],
            ['key' => 'expert', 'title' => 'سؤالات کارشناسی', 'emoji' => '🛠️', 'ord' => 6],
            ['key' => 'legal', 'title' => 'سؤال حقوقی', 'emoji' => '⚖️', 'ord' => 7],
            ['key' => 'contracts', 'title' => 'قولنامه آماده', 'emoji' => '🧾', 'ord' => 8],
            ['key' => 'inspection_quick', 'title' => 'بازدید ۳ دقیقه‌ای', 'emoji' => '🔧', 'ord' => 9],
            ['key' => 'city_report', 'title' => 'گزارش شهر من', 'emoji' => '🏙️', 'ord' => 10],
            ['key' => 'instagram', 'title' => 'ایده/کپشن/هشتگ', 'emoji' => '✍️', 'ord' => 11],
            ['key' => 'help', 'title' => 'راهنما', 'emoji' => '📘', 'ord' => 12],
            ['key' => 'account', 'title' => 'حساب من', 'emoji' => '👤', 'ord' => 13],
            ['key' => 'payments', 'title' => 'پرداخت/اشتراک', 'emoji' => '💳', 'ord' => 14],
            ['key' => 'support', 'title' => 'پشتیبانی', 'emoji' => '🆘', 'ord' => 15],
        ];
        foreach ($items as $i) {
            DB::table('menu_items')->updateOrInsert(['key' => $i['key']], array_merge($i, [
                'enabled' => true,
                'visible_roles' => json_encode(['dealer','novice','showroom','buyer']),
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}

