<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PromptConfigsSeeder extends Seeder
{
    public function run(): void
    {
        $modules = [
            ['module' => 'valuation', 'model' => 'gpt-4o-mini', 'enable_file_search' => true],
            ['module' => 'negotiation', 'model' => 'gpt-4o-mini', 'enable_file_search' => true],
            ['module' => 'expert', 'model' => 'gpt-4o-mini', 'enable_file_search' => true],
            ['module' => 'legal', 'model' => 'gpt-4o-mini', 'enable_file_search' => true],
            ['module' => 'inspection', 'model' => 'gpt-4o-mini', 'enable_file_search' => true],
            ['module' => 'instagram', 'model' => 'gpt-4o-mini', 'enable_file_search' => false],
        ];
        foreach ($modules as $m) {
            DB::table('prompt_configs')->updateOrInsert(['module' => $m['module']], array_merge($m, [
                'temperature' => 0.7,
                'top_p' => 1.0,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}

