<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RolesSeeder extends Seeder
{
    public function run(): void
    {
        // Create roles
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $userRole = Role::firstOrCreate(['name' => 'user']);

        // Create permissions
        $permissions = [
            'manage-users',
            'manage-opportunities',
            'manage-featured-ads',
            'manage-tickets',
            'manage-settings',
            'view-analytics',
            'manage-push-campaigns',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Assign all permissions to admin
        $adminRole->syncPermissions($permissions);

        // Create default admin user if doesn't exist
        $adminUser = User::firstOrCreate(
            ['tg_id' => '999999999'], // Admin telegram ID
            [
                'role' => 'admin',
                'plan' => 'admin',
                'password' => bcrypt('admin123'),
                'email_verified_at' => now(),
            ]
        );

        // Assign admin role
        if (!$adminUser->hasRole('admin')) {
            $adminUser->assignRole('admin');
        }

        $this->command->info('Roles and permissions seeded successfully!');
        $this->command->info('Admin user: admin@hajibot.com / admin123');
    }
}
