<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // General Settings
            [
                'key' => 'app.name',
                'value' => 'Telegram Bot Template',
                'type' => 'string',
                'category' => 'general',
                'description' => 'Application name displayed to users',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'app.timezone',
                'value' => 'Asia/Tehran',
                'type' => 'string',
                'category' => 'general',
                'description' => 'Default application timezone',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'app.locale',
                'value' => 'fa',
                'type' => 'string',
                'category' => 'localization',
                'description' => 'Default application language',
                'is_active' => true,
                'sort_order' => 1
            ],

            // Telegram Bot Settings
            [
                'key' => 'telegram.bot_token',
                'value' => '',
                'type' => 'string',
                'category' => 'telegram',
                'description' => 'Telegram Bot API Token',
                'is_active' => true,
                'is_encrypted' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'telegram.webhook_url',
                'value' => '',
                'type' => 'string',
                'category' => 'telegram',
                'description' => 'Webhook URL for receiving updates',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'telegram.max_message_length',
                'value' => 4096,
                'type' => 'integer',
                'category' => 'telegram',
                'description' => 'Maximum message length for Telegram',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'key' => 'telegram.rate_limit_enabled',
                'value' => true,
                'type' => 'boolean',
                'category' => 'telegram',
                'description' => 'Enable rate limiting for bot requests',
                'is_active' => true,
                'sort_order' => 4
            ],

            // Security Settings
            [
                'key' => 'security.admin_chat_ids',
                'value' => [],
                'type' => 'array',
                'category' => 'security',
                'description' => 'Chat IDs of admin users (JSON array)',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'security.maintenance_mode',
                'value' => false,
                'type' => 'boolean',
                'category' => 'security',
                'description' => 'Enable maintenance mode',
                'is_active' => true,
                'sort_order' => 2
            ],

            // Analytics Settings
            [
                'key' => 'analytics.enabled',
                'value' => true,
                'type' => 'boolean',
                'category' => 'analytics',
                'description' => 'Enable user analytics tracking',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'analytics.retention_days',
                'value' => 90,
                'type' => 'integer',
                'category' => 'analytics',
                'description' => 'Days to retain analytics data',
                'is_active' => true,
                'sort_order' => 2
            ],

            // Payment Settings (for Iranian market)
            [
                'key' => 'payment.zarinpal.merchant_id',
                'value' => '',
                'type' => 'string',
                'category' => 'payment',
                'description' => 'Zarinpal Merchant ID',
                'is_active' => true,
                'is_encrypted' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'payment.zarinpal.sandbox_mode',
                'value' => true,
                'type' => 'boolean',
                'category' => 'payment',
                'description' => 'Enable Zarinpal sandbox mode for testing',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'key' => 'payment.currency',
                'value' => 'IRR',
                'type' => 'string',
                'category' => 'payment',
                'description' => 'Default currency (Iranian Rial)',
                'is_active' => true,
                'sort_order' => 3
            ],

            // Notification Settings
            [
                'key' => 'notifications.broadcast_enabled',
                'value' => true,
                'type' => 'boolean',
                'category' => 'notification',
                'description' => 'Enable broadcast messaging',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'notifications.max_batch_size',
                'value' => 100,
                'type' => 'integer',
                'category' => 'notification',
                'description' => 'Maximum messages per broadcast batch',
                'is_active' => true,
                'sort_order' => 2
            ],

            // System Settings
            [
                'key' => 'system.debug_mode',
                'value' => false,
                'type' => 'boolean',
                'category' => 'system',
                'description' => 'Enable debug logging',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'key' => 'system.cache_ttl',
                'value' => 3600,
                'type' => 'integer',
                'category' => 'system',
                'description' => 'Default cache TTL in seconds',
                'is_active' => true,
                'sort_order' => 2
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }

        $this->command->info('Settings seeded successfully!');
    }
}