<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use DefStudio\Telegraph\Models\TelegraphBot;

class TelegramBotSeeder extends Seeder
{
    public function run(): void
    {
        $token = config('telegraph.bots.default.token');

        if (!$token) {
            $this->command->warn('TELEGRAPH_TOKEN not configured, skipping bot creation');
            return;
        }

        $bot = TelegraphBot::updateOrCreate(
            ['token' => $token],
            ['name' => 'HajiBot']
        );

        $this->command->info("Telegram bot created/updated: {$bot->name} (ID: {$bot->id})");
    }
}
