# Acceptance Sheet — Hajibot (Laravel + Telegraph)

This document enumerates every feature and panel capability with precise acceptance criteria, test steps, and expected outcomes. Use it to validate the final delivery end‑to‑end.

## Legend
- Test: step(s) to perform
- Expect: observable outcome
- Data: DB rows/logs to verify

> **Status snapshot (2025-09-17):** Only the green checks below are achievable today. Items marked _planned_ still lack working code; leave them unchecked during QA.

## 1) Webhook & Infra
- Webhook registered and secured ✅
  - Test: `php artisan route:list | grep telegram`; `curl -i -X POST $APP_URL/api/telegram/webhook -H "X-Telegram-Bot-Api-Secret-Token: $TELEGRAPH_SECRET" -d '{}'`
  - Expect: route present; HTTP/200 `{ok:true}`
  - Data: onboarding/menu logs in `storage/logs/laravel.log`
- Queue & Scheduler _planned_
  - Test: `php artisan queue:work` + cron for `schedule:run`
  - Expect: scheduled jobs (PushScheduler/PaymentsReconcile) run on time
  - Data: (not wired yet)

## 2) Onboarding & Menu (Telegram)
- /start → role → city → budget → notif ✅
  - Test: complete flow via bot
  - Expect: shows main menu (hard-coded); city search via text works with aliases
  - Data: `users`: role, city_id, budget_range, notif_level set; events `Start`, `SelectCity`
- Main Menu parity (Reply Keyboard) ✅
  - Test: پس از آنبوردینگ، دکمه «🏠 منوی اصلی» را بزن یا «منوی اصلی/منو» بفرست
  - Expect: دقیقاً همان رفتار `/start` برای کاربر موجود (ReplyKeyboard پایدار + پیام منوی اصلی)؛ تطبیق با اموجی انجام می‌شود
  - Data: لاگ‌های `handleStartCommand` در `laravel.log` و عدم ارسال پیام تکراری اضافی
- Menu from DB _planned_
  - Test: change a `menu_items` title in admin → re-open menu
  - Expect: updated title visible

## 3) Phone Verification Gate (Optional)
- Gate enabled in Settings
  - Test: after onboarding, bot sends ReplyKeyboard with `request_contact=true`; tap [📱 ارسال شماره موبایل من]
  - Expect: contact received; if not self contact → reject politely; if self → saved; proceed
  - Data: `users.phone` (E.164); event `PhoneSubmitted`
- Gate policy
  - Test: `hard_gate` blocks features before phone; `soft_gate` allows limited access
  - Expect: behavior matches toggle

## 4) Channel Membership Gate (Optional)
- Gate enabled and channels configured
  - Test: after phone/onboarding, bot shows join links and [✅ عضو شدم]; join channels → tap confirm
  - Expect: membership verified via `getChatMember`; proceed only if all are members
  - Data: event `MembershipGatePassed`; failures logged

## 5) AI — Valuation (HTTP + Telegram)
- JSON structured output ✅ (HTTP)
  - Test: send car details via REST; request `response_format.type=json_object`
  - Expect: JSON with `{min,max,anchor,confidence:"low|medium|high",reasons[2..4]}`; retry on first invalid
  - Data: `chats` row with tokens when request has an authenticated user context; event `PriceCheck`
- Telegram hand-off ✅
  - Test: در چت آزاد پس از آنبوردینگ عبارت «۲۰۷ مدل ۱۴۰۰، ۸۰هزار، تهران، بدنه سالم» را بفرست.
  - Expect: خروجی متنی شامل بازه، لنگر، اعتماد، دلایل کوتاه؛ هیچ CTA تماس وجود ندارد؛ دکمه «تحلیل قیمت» و دکمه‌های داخلی فعال‌اند.
  - Data: `price_sessions` ذخیره می‌شود؛ رویداد `PriceCheck` فعلاً فقط در HTTP ثبت می‌شود (گَپ پوشش).

## 6) AI — Negotiation / Expert / Legal / Inspection / Instagram
- Negotiation
  - Test: scenario starters (مودب/قاطع/حقوقی) and guided Q&A
  - Expect: concise scripts and 3‑step plans; multi‑turn preserved
- Expert/Legal/Inspection/Instagram
  - Test: sample prompts; ensure bullets style and disclaimer for Legal; risk‑map for Inspection; IG outputs
  - Expect: conforms to templates

## 7) Affordable Ads (Live List) _planned_
- Listing/paging not implemented yet; button returns placeholder text.
- Only `⭐ ذخیره` on opportunity cards works (opportunity source only).

## 8) Opportunities Push & CTR
- Campaign send (sample)
  - Test: create a sample campaign (admin) → schedule → run scheduler
  - Expect: `push_logs.sent_at`/`delivered_at` filled; clicking CTA updates `clicked_cta_at`
  - Data: `push_logs` rows; CTR computable

## 9) Payments & Subscriptions (Zarinpal)
- Create ✅
  - Test: `POST /api/payments/create {plan}`; follow redirect (sandbox)
  - Expect: response includes `authority`, `redirect_url`
- Verify (idempotent) ✅
  - Test: call `GET /api/payments/verify?authority=...` twice
  - Expect: first → activate subscription; second → `ok` without re-activation
  - Data: `payments.status=ok`, `subscriptions.status=active`, event `UpgradeSuccess`
- Reconcile job _planned_ — queue schedule not wired.

## 10) Saved Ads & Tickets
- Saved Ads (Telegram opportunity) ✅ — save via inline keyboard; duplicate returns error.
- Saved Ads (HTTP, external sources) _planned_ — controllers still rely on placeholder auth.
- Tickets _planned_ — HTTP endpoints exist but no real user mapping or Telegram UI.

## 11) Filament Admin & RBAC
- RBAC
  - Test: non‑admin access to admin routes/panel
  - Expect: 403; admin has full access
- Resources
  - Test: CRUD for key resources (Users/Plans/Payments/Opportunities/…)
  - Expect: validation, filters, actions (approve/push/schedule, attach/detach)
- Settings
  - Test: toggles (phone/channel gate) and channels list
  - Expect: bot behavior respects toggles; channels changeable

## 12) KPIs & Reports
- KPI Queries
  - Test: run sample SQLs (p80 latency, CTR, Saved≥10%, D1, Payment success)
  - Expect: non‑empty, consistent values; CTR = clicks/delivered
- Daily Report
  - Test: schedule report (email/Telegram) with metrics and errors
  - Expect: arrives with last 24h stats

## 13) Security & Ops
- Secret rotation plan documented; secrets not logged
- Feature flags to disable modules on incident
- SimulateProtect blocks simulate in production
- Health checks documented and green

---

# Sign‑off Checklist
- [ ] Webhook secured and healthy
- [ ] Onboarding + Menu
- [ ] Phone Gate (if enabled)
- [ ] Channel Gate (if enabled)
- [ ] AI Valuation (JSON + logs)
- [ ] AI Other Modules
- [ ] Affordable Ads (list + save)
- [ ] Push + CTR
- [ ] Payments (idempotent verify + reconcile)
- [ ] Saved Ads + Tickets
- [ ] Admin Panel + RBAC + Settings
- [ ] KPIs computable + Daily report
- [ ] Security/Ops (runbooks + protections)
