# AI Prompts & Contracts (OpenAI Responses + RAG)

## Provider Contract (Responses API)
- Endpoint: `POST https://api.openai.com/v1/responses`
- Headers: `Authorization: Bearer $OPENAI_API_KEY`, `Content-Type: application/json`
- Request (example, valuation with JSON output):
```
{
  "model": "gpt-4o-mini",
  "input": [
    {"role": "system", "content": "[SYSTEM: valuation-fa v1]"},
    {"role": "user", "content": "206 تیپ2، 1399، 85هزار، تهران؛ بدنه سالم. بازه و 3 دلیل بده."}
  ],
  "store": true,
  "previous_response_id": "resp_abc" ,
  "tool_resources": {"file_search": {"vector_store_ids": ["VS_MAIN"]}},
  "response_format": {"type": "json_object"}
}
```
- Response (example envelope we return to clients):
```
{
  "json": {"min": 420, "max": 470, "anchor": 445, "confidence": "medium", "reasons": ["کم‌کار", "سال ۱۳۹۹", "سالم بدنه"]},
  "response_id": "resp_456",
  "token_in": 850,
  "token_out": 160,
  "latency_ms": 1200
}
```

## Valuation JSON Schema (Strict)
- Required keys: `min:int`, `max:int`, `anchor:int`, `confidence:"low|medium|high"`, `reasons:[string; 2..4]`
- Rules:
  - `min <= anchor <= max`
  - Range width appropriate (avoid `min==max` unless high confidence and strong evidence)
  - Each reason ≈ ≤ 30 chars FA (e.g., «کم‌کار», «سال ۱۳۹۹», «سالم بدنه»)
- Retry policy: 1 retry if schema invalid; fallback to friendly text with guidance.

## Memory Policy (Threads)
- Per module `chat_threads`: keep `last_response_id` and `expires_at` (e.g., 24h)
- Use `previous_response_id` to continue context.
- Eviction: on new thread start, expire old thread or when `expires_at < now()`.

## RAG / Vector Stores
- Stores: `VS_MAIN` (valuation/negotiation/expert/legal/inspection), `VS_IG` (instagram)
- Attach/detach files via VectorStoreService; track `openai_vector_store_id` and file `openai_file_id` with `tag`
- file_search enable per module:
  - valuation, negotiation, expert, legal, inspection → true
  - instagram → false
- File formats: UTF‑8 text/PDF; chunking and index handled by provider.

## Token Budgets & Timeouts
- Timeout: 20s, Retries: 1
- Prefer concise style; instruct model to avoid long outputs
- Latency/ms logged and returned; token_in/out logged to DB

## Prompts (FA System Templates)
- Valuation JSON (v1):
  - «کار تو: بازه منصفانه قیمت خودرو در ایران بده. خروجی JSON: {min,max,anchor,confidence, reasons[2..4]}.
  - ورودی‌ها: برند/مدل، سال، کارکرد، شهر، وضعیت بدنه.
  - اگر اطلاعات ناقص است، بازه را کمی وسیع‌تر کن و confidence را کاهش بده.»
- Valuation Reply (text):
  - «قیمت منصفانه را کوتاه و عمل‌محور اعلام کن؛ ابتدا بازه، سپس لنگر و میزان اطمینان؛ دو دلیل کوتاه اضافه کن.
  - از هرگونه دعوت به اقدام، درخواست تماس یا CTA صریح خودداری کن.»
- Valuation Analysis (text):
  - «تحلیل بازار خودرو را بولت‌وار و کوتاه بر اساس داده‌های رسمی/آگهی بگو.
  - صرفاً اطلاعات تحلیلی ارائه کن؛ از دعوت به اقدام یا CTA خودداری کن.»
- Negotiation (starter):
  - «هدف: سناریوهای مکالمه کوتاه، مودب/قاطع/حقوقی + پلن 3مرحله‌ای.
  - پاسخ‌ها کوتاه و عمل‌محور؛ حداکثر 4 بولت.»
- Expert Q&A:
  - «پاسخ کوتاه و عملی؛ 3 بولت؛ اگر عدم قطعیت وجود دارد، بگو و گزینه‌های جایگزین را ذکر کن.»
- Legal:
  - «پاسخ حقوقی کوتاه + دیسکلیمر ثابت. اگر اطلاعات ناقص بود، پرسش clarifying بده.»
- Inspection:
  - «سؤالات سریع (8–10)؛ در پایان Risk map کوتاه + قدم بعدی.»
- Instagram:
  - «سناریو + 2–3 کپشن کوتاه + 10 هشتگ؛ لحن حرفه‌ای و ساده.»

## Logging & Events
- Persist `chats`: user_id, module, role, text?, response_id, token_in, token_out, latency_ms
- Emit `PriceCheck` with {latency_ms, confidence, anchor}
