# Hajibot Current State (2025-09-30)

## 1. System Overview
- Telegram-first assistant for Iran's auto market handling onboarding, opportunity surfacing, valuation, and post-lead services (`app/Http/Controllers/TelegramWebhookController.php`).
- Data sources: MajidAPI (Bama latest/search/details, Divar scraping) plus internal scoring pipeline (`app/Services/Ads/*`).
- Pricing flow mixes official price lists with live classifieds and AI-generated explanations (`app/Services/Pricing/PriceService.php`, `app/Http/Controllers/AIController.php`).
- Supporting capabilities include payments (Zarinpal sandbox), saved ads, support tickets, inspections, and admin dashboards.

## 2. Tech Stack & Infrastructure
- Laravel 10, PHP 8.3, Composer 2.x.
- MySQL 8 (primary datastore) with database queue driver by default.
- Redis optional but not required; current queue + cache defaults to database.
- Background processing via Laravel queue workers and `schedule:run` cron (see `app/Console/Kernel.php`).
- Telegram integration powered by `defstudio/telegraph` (`config/telegraph.php`).
- AI integration uses OpenAI Responses API with optional file_search (`app/Services/AI/OpenAiProvider.php`, `config/ai.php`).
- Payments handled through `shetabit/multipay` (Zarinpal driver) (`app/Services/Payments/PaymentService.php`).
- Feature gating via custom middleware and config (`app/Http/Middleware/FeatureGuard.php`, `config/feature_flags.php`).

## 3. Core Application Modules

### 3.1 Telegram Messaging & User Experience
- Webhook endpoint `/api/telegram/webhook` handled by `app/Http/Controllers/TelegramWebhookController.php`.
- Onboarding flow collects role, city, budget, notifications, phone verification (`TelegramWebhookController::handleStartCommand`, `::handleOnboardingCallback`, `config/onboarding.php`).
- Main menu renders inline keyboards and routes callbacks to module handlers (valuation, negotiation, expert, legal, inspection, support, help, Instagram drafts).
- `app/Services/Messaging/TelegramBot.php` wraps the Telegraph SDK, normalizes UTF-8 payloads, and manages chat/bot persistence.
- Affordable ads and saved opportunities use dynamic keyboards with pagination and CTA actions mapped to database rows (`TelegramWebhookController::showOpportunities`, `::handleAdsCallback`).
- Free-text router maps user input to active module threads with AI backends when enabled (`TelegramWebhookController::routeFreeTextToActiveModule`).

### 3.2 Pricing & Valuation
- `app/Services/Pricing/PriceService.php` normalizes user input, pulls official price lists via Majid API (`tryOfficial`), falls back to classifieds aggregation (`tryAds`), applies adjustments, computes confidence, and returns human-readable reasons.
- `app/Http/Controllers/AIController.php` validates AI requests, routes to `OpenAiProvider`, enforces JSON schema, and records chats/events when user context exists.
- `config/pricing.php` & `config/ads.php` store MajidAPI credentials, thresholds, normalization maps, and smart-search behaviour.

### 3.3 Ads Ingestion & Opportunity Scoring
- Background jobs orchestrate pulling and scoring ads: `app/Jobs/BamaPullLatestJob.php`, `BamaSearchJob.php`, `BamaDetailsJob.php`, `DivarScrapeJob.php`, `ScoreOpportunitiesJob.php`.
- Services under `app/Services/Ads/` handle API calls (`MajidApiClient`), deduplication (`Deduper`), median computation (`CityMedianService`), normalization, and scoring (`OpportunityScorer`).
- Pipeline persists raw ads in `ads_raw`, dedupes, enriches, and promotes deals into `opportunities` and `featured_ads` tables (see migrations `2025_09_01_000008_create_ads_tables.php`, `2025_09_23_*`).
- Console commands in `app/Console/Commands/*` expose operators to run full/partial pipelines, inspect status, and load fixtures.

### 3.4 Payments & Subscriptions
- HTTP endpoints implemented in `app/Http/Controllers/PaymentsController.php` create, verify, and reconcile payments.
- `app/Services/Payments/PaymentService.php` calls Shetabit, stores `payments` rows, and handles graceful sandbox fallbacks.
- Subscription state lives in `plans`, `subscriptions`, `plan_entitlements`, `user_addons`, `wallet_ledger`, `trials` (migrations `2025_09_01_000003` through `2025_09_02_000005`).
- Growth entitlements resolved via `app/Services/Growth/EntitlementResolver.php` and `QuotaService.php` with config defaults (`config/quotas.php`, `config/growth.php`).

### 3.5 Saved Ads & Support
- `app/Http/Controllers/SavedAdsController.php` exposes CRUD for saved opportunities tied to Telegram users.
- Support tickets: `app/Http/Controllers/Support/TicketsController.php` (user submission/list) and admin replies via `app/Http/Controllers/Admin/TicketsController.php`.

### 3.6 Inspection & Expert Workflows
- `app/Services/Inspection/InspectionService.php` manages interactive inspection sessions stored in `inspections`.
- API endpoints under `/api/inspection/*` (`app/Http/Controllers/InspectionController.php`) start, answer, cancel, and fetch progress.
- Telegram orchestrates quick inspection flows and checklist delivery (`TelegramWebhookController::handleInspectionCallback`, `::sendBuyInspectionChecklist`).

### 3.7 Analytics & Event Tracking
- `app/Services/Analytics/EventBus.php` records user events in `events` table, creating stub users when necessary.
- `app/Jobs/PushOpportunitiesJob.php`, `PushFeaturedAdsJob.php`, and `PushSchedulerJob.php` deliver deals to Telegram users and record campaign metadata.

### 3.8 Admin Panel (Filament)
- Dozens of resources scaffolded under `app/Filament/Resources` covering users, menu items, prompts, opportunities, featured ads, scrape profiles, payments, growth objects, etc.
- Pages for Analytics and Settings exist (`app/Filament/Pages/*`) but contain minimal implementation; UI wiring remains largely placeholder.

## 4. API & Integration Surface
| Method | Path | Controller | Feature |
| --- | --- | --- | --- |
| POST | `/api/ai/respond` | `AIController@respond` | OpenAI valuation/assistant (rate-limited, feature.guard:pricecheck).
| POST | `/api/payments/create` | `PaymentsController@create` | Initiate Zarinpal payment, returns redirect URL.
| GET | `/api/payments/verify` | `PaymentsController@verify` | Verify payment authority (sandbox-friendly).
| POST | `/api/payments/reconcile` | `PaymentsController@reconcile` | Idempotent reconcile hook.
| GET | `/api/user/saved_ads` | `SavedAdsController@index` | List saved deals (feature.guard:view_deals).
| POST | `/api/user/saved_ads` | `SavedAdsController@store` | Save an opportunity.
| DELETE | `/api/user/saved_ads/{id}` | `SavedAdsController@destroy` | Remove saved deal.
| POST | `/api/support/tickets` | `Support\TicketsController@store` | Submit support ticket.
| GET | `/api/support/tickets` | `Support\TicketsController@index` | List user tickets.
| POST | `/api/admin/tickets/{id}/reply` | `Admin\TicketsController@reply` | Admin response (role:admin).
| POST | `/api/admin/opportunities/push` | `Admin\OpportunitiesController@push` | Trigger push campaign (feature.guard:instant_push).
| POST | `/api/admin/featured_ads/push` | `Admin\FeaturedAdsController@push` | Trigger featured push (feature.guard:instant_push).
| GET | `/api/admin/opportunities` | `Admin\OpportunitiesController@index` | Review opportunities (role:admin).
| POST | `/api/simulate/click` | `SimulateController@click` | Local-only push analytics simulator (middleware simulate.protect).
| POST | `/api/inspection/start` | `InspectionController@start` | Start inspection session (auth:sanctum).
| POST | `/api/inspection/{inspection}/answer` | `InspectionController@answer` | Submit inspection answer (auth:sanctum).
| GET | `/api/inspection/{inspection}` | `InspectionController@show` | Retrieve inspection session.
| GET | `/api/inspection/{inspection}/progress` | `InspectionController@progress` | Progress summary.
| POST | `/api/inspection/{inspection}/cancel` | `InspectionController@cancel` | Cancel inspection.
| POST | `/api/telegram/webhook` | `TelegramWebhookController@handle` | Telegram updates (Telegraph secret header expected).

## 5. Background Jobs & Scheduling
- Scheduled in `app/Console/Kernel.php`:
  - `PushSchedulerJob` at 09:00, 11:00, 14:00 (cron `0 9,11,14 * * *`).
  - `ScoreOpportunitiesJob` every 30 minutes.
  - `GrowthDailyJob` daily at 02:00.
  - `PaymentsReconcileJob` hourly.
  - `GenerateCityReportJob` weekly Sunday 03:00.
- Queue workers expected to run `default` queue with retries/backoff.
- Additional jobs dispatched by controllers/services: campaign pushes, ad ingestion, inspection flows.

## 6. Console Commands (Operators)
Examples under `app/Console/Commands/`:
- `ads:status`  live stats for raw ads, opportunities, featured ads (`AdsSystemStatus.php`).
- `ads:run`, `ads:test`, `ads:process` variants  orchestrate ingestion pipelines (RunAdsSystem.php, ProcessAdsQueue.php, etc.).
- `ads:fixtures` (`CreateTestData.php`, `TestCompleteSystem.php`)  seed demo data for Telegram experience.
- `ads:scrape-specific` (`ScrapeSpecificCars.php`)  target specific brand/city.
- `telegram:setup` (`SetupTelegramBot.php`)  bootstrap Telegraph bot and webhook.
- `menu:show` (`ShowCarMenu.php`)  debug inline keyboards.

## 7. Data Model Highlights
Key tables created/managed by migrations in `database/migrations/`:
- Core users & auth: `users`, `personal_access_tokens`, `password_reset_tokens`.
- Geography: `cities`, `city_aliases`, `city_reports`.
- Pricing sessions: `price_sessions` (cache AI requests).
- Content & menus: `menu_items`, `prompt_configs`, `legal_files`, `checklists`.
- Vector stores: `vector_stores`, `vector_files` (OpenAI file search stubs).
- Ads pipeline: `ads_raw`, `opportunities`, `featured_ads`, `scrape_profiles`, `user_search_sessions`.
- Growth & monetisation: `plans`, `plan_entitlements`, `subscriptions`, `payments`, `wallet_ledger`, `trials`, `addons`, `user_addons`, `referral_links`, `referral_events`, `cancellations`.
- Support & engagement: `saved_ads`, `tickets`, `events`, `chat_threads`, `chats`.
- Inspection: `inspections` with JSON based questionnaire state.

## 8. Configuration & Feature Flags
- Feature toggles (`config/feature_flags.php`) govern Telegram modules (valuation, negotiation, expert, legal, inspection, affordable_ads, instagram).
- Per-module AI defaults (`config/ai.php`) set models, retries, file-search usage.
- Onboarding knobs (`config/onboarding.php`) control phone verification gates, channel requirements, fuzzy city matching.
- Ads thresholds & brand normalization in `config/ads.php`; pricing tokens in `config/pricing.php`.
- Growth/quotas parameters in `config/growth.php` and `config/quotas.php`.
- Payments callback URL and merchant settings in `config/payments.php` (expects Zarinpal sandbox/live env vars).

## 9. Observability & Logging
- Controllers/services use structured context via `Log::withContext` and `Log::info/warning/error` (see `PriceService::estimate`, `TelegramBot::sendMessage`).
- Logging policy emphasises correlation IDs (`price_ctx`, `req_id`, `tg_id`) and categorised channels (`price.*`, `tg.*`, `payments.*`).
- Failures in background jobs bubble through Laravel job logging; retries configured per worker invocation.

## 10. Runbook Snapshot
- Environment setup: `composer install`, copy `.env`, configure DB, `php artisan key:generate`, migrate/seed (`php artisan migrate --seed`).
- Queue: run `php artisan queue:work --queue=default --tries=3 --backoff=5` (or cron-driven `queue:work --stop-when-empty` on shared hosting).
- Scheduler: system cron `* * * * * php /path/to/artisan schedule:run` to execute `Kernel` jobs.
- Telegram: ensure `TELEGRAPH_TOKEN`/`TELEGRAPH_SECRET` set, webhook configured to `/api/telegram/webhook` with secret header, run `php artisan telegram:setup` if needed.
- Payments: sandbox flows require `ZARINPAL_MERCHANT_ID`, `ZARINPAL_CALLBACK_URL`, `APP_URL`; verification gracefully degrades when Shetabit fails.

## 11. Testing & QA Notes
- Automated tests minimal (check `tests/` for scaffolding); rely on artisan commands + manual Telegram walkthrough.
- Smoke checklist: onboarding `/start`, viewing opportunities, saving deals, invoking `/api/ai/respond`, executing payments sandbox callbacks, dispatching ingestion jobs (see `SUMMARY.md`).
- Feature guards (`feature.guard:*`) enforce staged rollouts; use config toggles to simulate enable/disable scenarios.

## 12. Known Gaps & TODOs (from code review)
- Several Telegram modules reply with placeholders despite being flagged true (negotiation, expert, legal, instagram)  handler stubs exist but need real flows (`TelegramWebhookController::*Input`).
- Payments APIs tie `user_id` fallback to 1 when unauthenticated; needs Telegram-to-HTTP auth bridge.
- Admin Filament resources scaffolded but unstyled; business widgets and permissions pending.
- Vector store service is a stub (`app/Services/Content/VectorStoreService.php`).
- Growth funnels (referrals, challenges, wallet ledger) lack triggers from Telegram/API flows.
- Encoding issues persist in seeded Persian strings across commands and docs; convert to UTF-8 to avoid garbled output.

## 13. Reference Checklist
- Review `docs/` companion files for deep dives (Architecture, Runbook, Logging, PRD, Roadmap, etc.)  all synchronised with this source on 2025-09-30.
- Keep documentation synced using `docs/DOCUMENTATION_GUIDE.md` practices; update feature toggles and migrations when adding modules.