# راهنمای اسناد پروژه — Hajibot

هدف: این سند می‌گوید هر فایل مستندات چه محتوایی باید داشته باشد، چه زمانی باید خوانده و چه زمانی باید به‌روزرسانی شود، و قوانین نگه‌داری اسناد همگام با کد چیست.

## اصول و قوانین کلی
- Docs-as-code: هر تغییری که API/اسکیما/رفتار را تغییر می‌دهد، باید با به‌روزرسانی اسناد مرتبط در همان PR بیاید.
- منبع حقیقت (Source of Truth):
  - Product: `PRD.md`
  - Tech: `ARCHITECTURE.md`
  - Interface: `API_SPEC.internal.md`
  - Data: `ERD.mmd` + مایگریشن‌ها
- هویت و نسخه: هر سند باید «آخرین ویرایش» و «نویسنده/مسئول» را در بالای فایل درج کند.
- سبک نگارش: کوتاه، عمل‌محور، بولت‌وار؛ حداکثر 4–6 بولت در هر بخش؛ بدون حشو.
- دید محصول/کسب‌وکار/مارکتینگ: توسعه نباید صرفاً کدنویسی باشد؛ هر تغییر باید ارزش کاربر، مسیر فعال‌سازی (Activation) و اثر بر KPI را بهبود دهد. پیام‌ها (کپی‌رایتینگ) روشن، بدون ابهام، راهنمای گام‌به‌گام و سازگار با لحن برند باشد.
- هم‌مرجع‌دهی: بین اسناد مرتبط لینک/ارجاع متقابل بدهید (مثلاً API به Test Plan).
- بازبینی: Reviewer موظف است «هم‌راستایی کد/اسناد» را بررسی کند؛ PR بدون اسناد مربوطه «قابل ادغام نیست» مگر با پذیرش صریح استثنا.

## چه چیزی را چه زمانی بخوانیم؟
- عضو جدید تیم (Onboarding): `PRD.md` → `Product design.md` → `ARCHITECTURE.md` → `API_SPEC.internal.md` → `RUNBOOK.md`.
- توسعه بک‌اند فیچر: `REQUIREMENTS_CHECKLIST.md` → `API_SPEC.internal.md` → سند حوزه (مثل `TELEGRAM_UX.md`, `AI_PROMPTS_AND_CONTRACTS.md`, `ADS_INGESTION_AND_SCORING.md`) → `TEST_PLAN.md` → `LOGGING_POLICY.md`.
- عملیات/DevOps: `RUNBOOK.md` → `LOGGING_POLICY.md` → `RISK_REGISTER.md` → `KPI_READINESS.md` → `QUALITY_GATES.md`.
- مدیریت/PM: `PRD.md` → `ROADMAP_0_TO_LAUNCH.md` → `PROJECT_STATUS.md` → `ACCEPTANCE_SHEET.md`.
- QA: `ACCEPTANCE_SHEET.md` → `TEST_PLAN.md` → `API_SPEC.internal.md`.

## کپی‌رایتینگ و UX (راهنمای سریع)
- لحن: رک، محترم، عمل‌محور؛ از جملات بلند پرهیز کن.
- راهنمایی: در هر پیام یک CTA واضح؛ دکمه‌ها کم‌تعداد و گویا.
- خطا/استیت خالی: علت + راه‌حل (نه «در حال توسعه است» در مسیرهای اصلی).
- سازگاری: نام ماژول‌ها/دکمه‌ها/ترمینولوژی در همه‌جا یکی باشد.

## چه فایلی چه چیزی دارد و چه زمانی به‌روزرسانی می‌شود؟
- PRD.md
  - محتوا: چشم‌انداز محصول، ارزش‌ها، دامنه، قیود، سنجه‌ها.
  - به‌روزرسانی: به‌ندرت (تغییر دامنه/اهداف)، با تایید محصول.
- Product design.md
  - محتوا: جریان‌ها/UX، منوها، نقش‌ها، دکمه‌ها و لحن پیام‌ها.
  - به‌روزرسانی: هر بار تغییر UX/متن/منو یا افزودن جریان جدید.
- ARCHITECTURE.md
  - محتوا: پشته، لایه‌ها، تصمیمات فنی، وابستگی‌ها.
  - به‌روزرسانی: تغییر معماری/وابستگی/الگوی سرویس/Job.
- API_SPEC.internal.md
  - محتوا: مسیرها، DTOها، شکل خطا، قراردادها و Idempotency.
  - به‌روزرسانی: «همزمان با هر تغییر API/روت/پیلود». منبع حقیقت اینترفیس است.
- TELEGRAM_UX.md
  - محتوا: /start، آنبوردینگ، Callback schema، گیت‌ها، منو و پیام‌ها.
  - به‌روزرسانی: هر تغییر جریان تلگرام/منو/گیت.
- ADS_INGESTION_AND_SCORING.md
  - محتوا: majidapi endpoints، نرمال‌سازی/دیوپ/میانه‌شهر/اسکور/TTL.
  - به‌روزرسانی: تغییر آستانه‌ها، الگوریتم یا منابع داده.
- AI_PROMPTS_AND_CONTRACTS.md
  - محتوا: Provider/مدل‌ها، RAG، حافظه، قالب پاسخ (JSON)، بودجه/Timeout.
  - به‌روزرسانی: تغییر مدل/پرومپت/سیاست حافظه/RAG.
- FILAMENT_ADMIN_SPEC.md
  - محتوا: منابع/فیلدها/فیلترها/اکشن‌ها/ویجت‌ها.
  - به‌روزرسانی: هر افزودن/تغییر Resource/ویجت.
- RUNBOOK.md
  - محتوا: نصب/پیکربندی/دیپلوی/Queue/Schedule/Health/Trblshoot.
  - به‌روزرسانی: هر تغییر رویه عملیاتی، پیش‌نیاز، کانفیگ محیط.
- ROADMAP_0_TO_LAUNCH.md
  - محتوا: مسیر 0→لانچ، مایلستون/«تعریف پذیرش» هر گام.
  - به‌روزرسانی: پس از اتمام هر مایلستون/تغییر برنامه.
- TASKS.todo.md
  - محتوا: کارهای اتمیک نزدیک.
  - به‌روزرسانی: هفتگی/پس از هر اسپرینت.
- TEST_PLAN.md
  - محتوا: تست‌های فیچر/یکپارچه/ماک‌ها/فیچرگارد/کوتا.
  - به‌روزرسانی: همراه هر فیچر/اندپوینت جدید یا تغییر رفتار.
- ACCEPTANCE_SHEET.md
  - محتوا: معیار پذیرش نهایی و گام‌های تست End‑to‑End.
  - به‌روزرسانی: پیش از ریلیز کاندید و پس از بازبینی QA.
- KPI_READINESS.md
  - محتوا: تعریف KPI، پوشش فعلی، کوئری نمونه، شکاف‌های ابزارگذاری.
  - به‌روزرسانی: هر تغییر ابزارگذاری/ایونت/چارت.
- QUALITY_GATES.md
  - محتوا: بودجه پرفورمنس، قرارداد داده، گیت‌های قابلیت/اعتمادی.
  - به‌روزرسانی: تغییر بودجه/گیت/قبول-رد.
- REQUIREMENTS_CHECKLIST.md
  - محتوا: چک‌لیست ردیابی نیازمندی‌ها به PRD.
  - به‌روزرسانی: با تکمیل/تغییر فیچرها.
- OPEN_QUESTIONS.md
  - محتوا: ابهامات باز.
  - به‌روزرسانی: مستمر تا زمان تصمیم.
- GAPS_AND_ACTIONS.md
  - محتوا: شکاف‌ها (Severity) و اقدامات/مالک/تست.
  - به‌روزرسانی: پس از هر کشف/حل شکاف.
- RISK_REGISTER.md
  - محتوا: ریسک‌ها/کاهش‌ها/آستانه هشدار.
  - به‌روزرسانی: با تغییر محیط/یکپارچه‌سازی/SLAs.
- ERD.mmd
  - محتوا: نمودار موجودیت‌ها و روابط + چک‌لیست نرمال‌سازی.
  - به‌روزرسانی: «با هر تغییر اسکیما/مایگریشن».
- PROJECT_STATUS.md
  - محتوا: وضعیت اجرایی/فازها/گپ‌ها.
  - به‌روزرسانی: ماهانه یا پس از تغییر بزرگ.
- LOGGING_POLICY.md
  - محتوا: سیاست لاگ، سطوح، کلیدها، PII، آلارم‌ها، نمونه‌ها.
  - به‌روزرسانی: با تغییر نقاط لاگ/کلیدها/آستانه‌ها.

## چک‌لیست به‌روزرسانی اسناد در PR
- آیا مسیر/DTO/اسکیما عوض شد؟ → `API_SPEC.internal.md`, `ERD.mmd`, `TEST_PLAN.md`.
- آیا UX تلگرام یا منو عوض شد؟ → `TELEGRAM_UX.md`, `Product design.md`.
- آیا زمان‌بند/صف/دیپلوی تغییر کرد؟ → `RUNBOOK.md`.
- آیا الگوریتم Ads/AI/Quota تغییر کرد؟ → سند حوزه مربوطه.
- آیا گیت کیفیت/بودجه تغییر کرد؟ → `QUALITY_GATES.md`, `KPI_READINESS.md`.
- آیا رخدادهای لاگ جدید اضافه شد؟ → `LOGGING_POLICY.md`.
- آیا ریسک/گپ جدید شناسایی شد؟ → `RISK_REGISTER.md`, `GAPS_AND_ACTIONS.md`.
- آیا مسئول/مالک عوض شد؟ → سرآیند «مسئول» هر سند را به‌روزرسانی کن.

## قواعد یکپارچگی با کدبیس
- نام‌گذاری یکنواخت کلیدها/ماژول‌ها در اسناد و کد (`valuation`, `instant_push`, `view_deals`).
- هر جا کلیدی تغییر می‌کند (مثلاً FeatureGuard)، تمام ارجاعات سندی و کدی همگام شوند.
- در Commitها از پیشوندهای توصیفی استفاده کنید: `[docs]`, `[api]`, `[schema]`, `[ops]`.

## نمونه سرآیند سند
```
آخرین ویرایش: 1404/06/24 — مسئول: backend@team
وضعیت: پایدار | پیش‌نویس
دامنه: …
```

## نگه‌داری و بازبینی دوره‌ای
- بازبینی ماهانه: `ROADMAP_0_TO_LAUNCH.md`, `PROJECT_STATUS.md`, `GAPS_AND_ACTIONS.md`.
- بازبینی هر ریلیز: `ACCEPTANCE_SHEET.md`, `QUALITY_GATES.md`, `RUNBOOK.md`.
- بازبینی پس از رخداد: `RISK_REGISTER.md`, `LOGGING_POLICY.md`, `KPI_READINESS.md`.

---

این راهنما «الزامی» است. هر فیچر بدون اسناد هم‌راستا «ناقص» تلقی می‌شود.
